//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 7:Second law of thermodynamics
//Example:7.7
//Title:Clausius inequality
//What will be del Q by delT if engine is reversible and work done by engine
model Ex7_7

//================
//parameter section
parameter Real T1(unit="K")=480"temperature of the second reservoir";
parameter Real T2(unit="K")=300"temperature of the first reservoir";
parameter Real Q(unit="kJ/min")=50"rate at which energy is released";

//================
//variable section
Real dQ(unit="kJ/min")"value to choose the medium";
Real n(unit="dimensionless")"efficiency of the reversible engine";
Real W(unit="kW")"work delivered";
Real Q2(unit="kJ/min")"enenrgy released in second case";
Real dQ1(unit="kJ/min")"to calculate dQ/T";

//===================
//equation section
equation
dQ=(Q/T1)-(Q/T2);
n=1-(T2/T1);
W=n*Q/60;//divided by 60 to convert kJ/min to kW
Q2=Q-(W*60);
dQ1=(Q/T1)-(Q2/T2);
//Remarks dQ1 has a very low value of 10^(-17) so taken as 0 in book
end Ex7_7;
