//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 8:Thermodynamic Relations
//Example:8.1
//Title:Thermodynamic Potentials
//Calculate work that can be obtained during expansion process
model Ex8_1

//================
//parameter section
parameter Real P1(unit="bar")=10"Pressure of the superheated steam";
parameter Real T1(unit="deg C")=300"Temperature of the superheated steam";
parameter Real P2(unit="deg C")=1"Pressure due to adiabatic expansion";

//===============
//variable section
Real h1(unit="kJ/kg")"enthalpy in the first case";
Real S1(unit="kJ/kg.K")"entropy in the first case";
Real v1(unit="m^3/kg")"specific volume in the first case";
Real sg(unit="kJ/kg.K")"entropy in the vapour state";
Real sf(unit="kJ/kg.K")"entropy in the liquid state";
Real X2(unit="dimensionless")"quality of the steam";
Real h2(unit="kJ/kg")"enthalpy in the second case";
Real hf(unit="kJ/kg")"enthalpy in the liquid state";
Real hg(unit="kJ/kg")"enthalpy in the vapor state";
Real v2(unit="m^3/kg")"specific volume in the second case";
Real vf(unit="m^3/kg")"specific volume in liquid state";
Real vg(unit="m^3/kg")"specific volume in vapor state";
Real u1(unit="kJ/kg")"internal energy in first case";
Real u2(unit="kJ/kg")"internal energy in the second case";
Real W(unit="kJ")"work done during the expansion process";

//================
//equation section
equation
//Refer to steam table in appendix in book and refer to book Pg no:291 for the value of h1,hf,hg,vf,vg,S1
h1=3052.1;
v1=0.2580;
u1=((h1*10^3)-(P1*10^5*v1))/1000;
S1=7.1251;
sg=7.3598;
sf=1.3027;
S1=(X2*sg)+((1-X2)*sf);
hg=2675.4;
hf=417.54;
h2=(X2*hg)+((1-X2)*hf);
vg=1.694;
vf=0.0010434;
v2=(X2*vg)+((1-X2)*vf);
u2=((h2*10^3)-(P2*10^5*v2))/1000;
W=u1-u2;
//Remarks:value of u2 is given as 2424.54 in the book but the original answer is 2425.07 which is error in book
end Ex8_1;
