//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 8:Thermodynamic Relations
//Example:8.11
//Title:Kirchoff equation
//Estimate latent heat of vaporisation of water at 120 celsius

model Ex8_11

//====================
//parameter section
parameter Real T1(unit="deg C")=100"temperature at latent heat of vaporization is available";
parameter Real hfg1(unit="kJ/kg")=2256.94"latent heat of vaporization at 100 deg C";
parameter Real T2(unit="deg C")=120"temperature to calculate latent heat of vaporization";
parameter Real Cpf(unit="kJ/kg.K")=4.23"specific heat of liquid water";
parameter Real Cpg(unit="kJ/kg.K")=1.55"specific heat of vapor";

//====================
//variable section
Real hfg2(unit="kJ/kg")"latent heat of vaporisation at final temperature";

//====================
//equation section
equation
hfg2-hfg1=(Cpg-Cpf)*(T2-T1);
end Ex8_11;
