//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 8:Thermodynamic Relations
//Example:8.3
//Title:Thermodynamic Potentials
//Calculate power output from an adiabatic and reversible steam turbine 

model Ex8_3

//======================
//parameter section
parameter Real P1(unit="bar")=8"Pressure of the superheated steam";
parameter Real T1(unit="deg C")=250"Temperature of the superjeated steam";
parameter Real M(unit="kg/s")=1"Rate at which steam flows";
parameter Real P2(unit="bar")=1"Pressure at which the steam leaves";

//======================
//variable section
Real Xe(unit="dimensionless")"quantity of the steam";
Real hi(unit="kJ/kg")"enthalpy of the steam";
Real si(unit="kJ/kg.K")"entropy of the steam";
Real hg(unit="kJ/kg")"enthalpy in the vapor state";
Real hf(unit="kJ/kg")"enthalpy in the liquid state";
Real sg(unit="kJ/kg.K")"entropy in the vapor state";
Real sf(unit="kJ/kg.K")"entropy in the liquid state";
Real W(unit="kW")"Power output";
Real he(unit="kJ/kg")"enthalpy";
//Real X2(unit="dimensionless")"quality of the steam";

//=====================
//equation section
equation
//Refer to book Pg no:294 for the value of hi,si,hg,hf
hi=2947.95;
si=7.0248;
sg=7.3598;
sf=1.3027;
si=(Xe*sg)+((1-Xe)*sf);
hg=2675.4;
hf=417.54;
he=(Xe*hg)+((1-Xe)*hf);
W=hi-he;
//Remarks:value of W is give as 396.73 in book but the original answer is 397.425 which is error beacause Xe is approximated to 0.95
end Ex8_3;
