//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 8:Thermodynamic Relations
//Example:8.4
//Title:Thermodynamic Potentials
//Determine minimum power required to separate one kmol per h of air at 100kPa and 300K into pure components
model Ex8_4

//==================
//parameter section
parameter Real P(unit="kPa")=100"Pressure of the air";
parameter Real T(unit="K")=300"Temperature of the air";
parameter Real Ts(unit="K")=300"Temperature of the surrounding";
parameter Real XN2(unit="dimensionless")=0.79"Mole fraction of nitrogen in air";
parameter Real XO(unit="dimensionless")=0.21"mole fraction of oxygen in air";

//==================
//constant section
constant Real R(unit="J/mol.K")=8.314"gas constant";

//==================
//variable section
Real delS(unit="J/mol.K")"change in entropy";
Real W(unit="W")"minimum power required";

//==================
//equation section
equation
delS=R*T*((XN2*log(XN2))+(XO*log(XO)));
W=-(delS*1000)/3600;//power required 
end Ex8_4;
