//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 8:Thermodynamic Relations
//Example:8.9
//Title:Specific heat Relations
//Estimate the rise in temperature if liquid water at 25 celsius iscompressed isentropically
model Ex8_9

//=====================
//parameter section
parameter Real T(unit="deg C")=25"Temperature of the liquid water";
parameter Real P1(unit="MPa")=0.1"Pressure initially";
parameter Real P2(unit="MPa")=10"Pressure finally";
parameter Real Cp(unit="kJ/kg.K")=4.2"specific heat at constant pressure";
parameter Real beta(unit="K^(-1)")=2.07*10^(-4)"Value of beta";

//====================
//variable section
Real vf(unit="m^3/kg")"specific volume of liquid water";
Real delTbydelP(unit="K/Pa")"del T/del P";
Real delT(unit="deg C")"Temperature Rise";

//===================
//equation section
equation
//Refer to book Pg no:310 for the value of vf
vf=0.0010029;
delTbydelP=((T+273)*vf*beta)/(Cp*10^3);
delT=delTbydelP*(P2-P1)*(10^6);//multiplied by 10^6 to convert MPa to Pa
end Ex8_9;
