//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 9:Power and Refrigration cylcle
//Example:9.1
//Title:Ideal Rankine cycle
//Calculate1 thermal eﬃciency of power plant 2rate of steam production 3eﬃciency
model Ex9_1

//=====================
//parameter section
parameter Real P1(unit="MPa")=3"Pressure of the superheated steam";
parameter Real T1(unit="deg C")=300"Temperature of the superheated steam";
parameter Real P2(unit="kPa")=5"Condenser Presuure";
parameter Real E1(unit="dimensionnless")=0.8"Efficiency of the Pump";
parameter Real E2(unit="dimensionless")=0.85"efficiency of the turbine";
parameter Real P(unit="MW")=1"Power output of the Plant";

//======================
//variable section
Real h1(unit="kJ/kg")"enthalpy when the steam expands";
Real v1(unit="m^3/kg")"Specific volume when the steam expands";
Real Wp(unit="kJ/kg")"work done when the steam expands";
Real h2(unit="kJ/kg")"enthalpy when the steam leaves the pump";
Real h4(unit="kJ/kg")"enthalpy of the superheated steam";
Real s4(unit="m^3/kg")"specific volume of the superheated steam";
Real h5(unit="kJ/kg")"enthalpy after the steam leaves the turbine";
Real q1(unit="kJ/kg")"heat released in the first stage";
Real sf(unit="m^3/kg")"specific volume in the liquid state of the condenser";
Real sg(unit="m^3/kg")"specific volume in the vapor state of the condenser";
Real hf(unit="kJ/kg")"enthalpy in the liquid state of the condenser";
Real hg(unit="kJ/kg")"enthalpy in the vapor state of the condenser";
Real X5(unit="dimensionless")"quantity of the steam";
Real n(unit="dimensionless")"Thermal efficiency";
Real PO(unit="kJ")"Power output";
Real SP(unit="kg/s")"steam production Rate";
Real TE(unit="dimensionless")"Thermal efficiency of an ideal Rankine cycle";

//======================
//equation section
equation
//refer to book Pg no:336 for the values of h1,v1,h4,s4,sf,sg,hf,hg
h1=137.77;
v1=0.0010052;
Wp=v1*(P1-(P2/1000))*10^3;
h2=h1+(Wp/E1);//Refer to book for the equation
h4=2995.1;
s4=6.5422;
q1=h4-h2;
sf=0.4763;
sg=8.3960;
hf=137.77;
hg=2561.6;
s4=(X5*sg)+((1-X5)*sf);
h5=(X5*hg)+((1-X5)*hf);
n=((E2*(h4-h5))-(Wp/E1))/(h4-h2);
PO=((E2*(h4-h5))-(Wp/E1));
SP=(P*10^6)/(PO*10^3);
TE=((h4-h5)-Wp)/(h4-hf+Wp);
end Ex9_1;
