//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004
//Chapter 9:Power and Refrigration cylcle
//Example:9.10
//Title:Refrigerants
//Calculate 1referigerant ﬂow rate through system 2energy input to compressor 3COP of system

package Ex9_10

model Ex9_10_a

//====================
//parameter section
parameter Real Pmin(unit="kPa")=150"minimum operating pressure of the refrigerant";
parameter Real Pmax(unit="kPa")=960"maximum operating pressure of the refrigerant";
parameter Real EC(unit="kJ/min")=300"energy transferred as heat from the condenser";
parameter Real Ee(unit="kJ/min")=211"energy absorbed from the evaporator";
parameter Real M(unit="ton")=1"capacity of the refrigirator";

//====================
//variable section
Real h1(unit="kJ/kg")"enthalpy at the minimum operating pressure";
Real h2(unit="kJ/kg")"enthalpy at the maximum operating pressure";
Real m(unit="kg/min")"refrigerant flow rate";

//====================
//equation section
equation

//Refer to book Pg no:371 for the value of h1,h2
h1=178.8372;
h2=75.1013;
Ee=m*(h1-h2);
end Ex9_10_a;

//===================

model Ex9_10_b
extends Ex9_10_a;

//===================
//variable section
Real W(unit="kJ/min")"work done on the compressor in kJ/min";
Real W1(unit="kW")"work done on the compressor in kW";

//===================
//equation section
equation
EC=Ee+W;
W1=W/60;//to convert kJ/min to kJ/s which is kW
end Ex9_10_b;

//===================

model Ex9_10_c
extends Ex9_10_a;
extends Ex9_10_b;

//==================
//variable section
Real COP(unit="dimensionless")"coefficient of performance on the the system";

//==================
//equation section
equation
COP=Ee/W;
end Ex9_10_c;
end Ex9_10;
