//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 9:Power and Refrigration cylcle
//Example:9.2
//Title:Reheat cycle
//Calculate thermal eﬃciency of plant
model Ex9_2

//====================
//parameter section
parameter Real P1(unit="MPa")=3"Pressure when the steam enters the turbine";
parameter Real T1(unit="deg C")=500"Temperature when the steam enters the turbine";
parameter Real P2(unit="MPa")=0.6"Pressure after expansion in the first turbine";
parameter Real T2(unit="deg C")=500"Temperature after it is reheated";
parameter Real P3(unit="kPa")=5"Pressure after it is expanded in the second turbine";
parameter Real E1(unit="dimensionless")=0.6"Efficiency of the pump";
parameter Real E2(unit="dimensionless")=0.8"Efficiency of the turbine";

//====================
//variable section
Real h4(unit="kJ/kg")"enthalpy when the steam enters the turbine";
Real s4(unit="m^3/kg.K")"entropy when the steam enters the turbine";
Real sg1(unit="kJ/kg.K")"entropy in the vapor state when the steam is expanded";
Real Wt1(unit="kJ/kg")"actual work done in the irst process";
Real h5(unit="kJ/kg")"enthalpy when the steam leaves the turbine";
Real h5a(unit="kJ/kg")"actual enthalpy when the steam leaves the turbine";
Real h6(unit="kJ/kg")"enthalpy after expansion";
Real s6(unit="kJ/kg.K")"entropy after expansion";
Real X7(unit="dimensionless")"quality of the steam sfter expansion";
Real hf(unit="kJ/kg")"enthalpy in the liquid state after expanding in the second turbine";
Real hg(unit="kJ/kg")"enthalpy in the vapor state after expanding in the second turbine";
Real sf(unit="kJ/kg.K")"entropy in the liquid state after expanding in the second turbine";
Real sg(unit="kJ/kg.K")"entropy in the vapor state after expanding in the second turbine";
Real h7(unit="kJ/kg")"enthalpy after expansion in the second turbine";
Real Wt2(unit="kJ/kg")"actual work done in the secondd turbine";
Real v(unit="m^3/kg")"specific volume of the steam after passing through the second turbine";
Real wp(unit="kJ/kg")"work done by the pump";
Real WPa(unit="kJ/kg")"actual work done by the pump";
Real h2(unit="kJ/kg")"enthalpy after leaving the pump";
Real n(unit="dimensionless")"thermal efficiency of the pump";

//====================
//equation section
equation
//Refer to steam table in the appendix in book Pg no:448 for the value of h4,s4
h4=3456.2;
s4=7.2345;
//Refer to steam table in the appendix in book Pg no:443 for the value of sg
sg1=6.7575;
h5=2989.59;//obtained by interpolation Refer to examples in CH:3 and refer to book fo the temperature for interpolation in book Pg no:340
Wt1=E2*(h4-h5);
h5a=h4-Wt1;
//Refer to steam table in the appendix in book Pg no:446 for the value of h6,s6
h6=3482.7;
s6=8.0027;
//Refer to steam table in the appendix in book Pg no:443 at 0.05 bar for the value of hf,hg,sf,sg
sf=0.4763;
sg=8.3960;
s6=(X7*sg)+((1-X7)*sf);
hf=137.77;
hg=2561.6;
h7=(X7*hg)+((1-X7)*hf);
Wt2=E2*(h6-h7);
v=0.001005;//Refer to Ex no:9.1 for the value of v;
wp=(v*(P1-(P3/1000))*10^6)/1000;
WPa=wp/E1;
h2=hf+WPa;
n=(Wt1+Wt2-WPa)/(h4-h2+h6-h5a);//Refer to book Pg no:341 for the equation
end Ex9_2;

//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 9:Power and Refrigration cylcle
//Example:9.3
//Title:Regenerative cycle
//Calculate thermal eﬁciency of power plant 

//==================
//parameter section
//parameter Real P1(unit="MPa")=3"Pressure of the steam supplied to the turbine";
//parameter Real T1(unit="deg C")"Temperature of the steam supplied to the turbine";
//parameter Real P2(unit="MPa")=0.4"Pressure of the steam withdrawn from the turbine";
//parameter Real P3(unit="bar")=0.1"final condenser pressure";

//===============
//variabl section
//Real hf1(unit="kJ/kg")"enthalpy in the liquid form for the condenser pressure";
//Real hg1(unit= "kJ/kg")"enthalpy in the vapor form for the condenser pressure";
//Real sf1(unit="kJ/kg.K")"entropy in the liquid form for the condenser pressure";
//Real sg1(unit="kJ/kg.K")"entropy in the vapor form for the condenser pressure";
//Real h(unit="kJ/kg")"enthalpy of the steam supplied to the turbine";
//sReal s(unit="kJ/kg.K")"entropy of the steam supplied to the turbine";
