//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 9:Power and Refrigration cylcle
//Example:9.3
//Title:Regenerative cycle
//Calculate thermal efﬁciency of power plant 
model Ex9_3

//==================
//parameter section
parameter Real P1(unit="MPa")=3"Pressure of the steam supplied to the turbine";
parameter Real T1(unit="deg C")=300"Temperature of the steam supplied to the turbine";
parameter Real P2(unit="MPa")=0.4"Pressure of the steam withdrawn from the turbine";
parameter Real P3(unit="bar")=0.1"final condenser pressure";

//===============
//variabl section
Real hf1(unit="kJ/kg")"enthalpy in the liquid form for the condenser pressure";
Real hg1(unit= "kJ/kg")"enthalpy in the vapor form for the condenser pressure";
Real sf1(unit="kJ/kg.K")"entropy in the liquid form for the condenser pressure";
Real sg1(unit="kJ/kg.K")"entropy in the vapor form for the condenser pressure";
Real h(unit="kJ/kg")"enthalpy of the steam supplied to the turbine";
Real s(unit="kJ/kg.K")"entropy of the steam supplied to the turbine";
Real hf(unit="kJ/kg")"enthalpy of the steam from the turbine which is in liquid state";
Real hg(unit="kJ/kg")"enthalpy of the steam from the turbine which is in vapor state";
Real sf(unit="kJ/kg.K")"entropy of the steam from the turbine which is in liquid state";
Real sg(unit="kJ/kg.K")"entropy of the steam from the turbine which is in vapor state";
Real h2(unit="kJ/kg")"enthalpy of the steam in the first stage";
Real h4(unit="kJ/kg")"enthalpy in the fourth stage";
Real h7(unit="kJ/kg")"enthalpy of the steam after leaving the turbine";
Real h8(unit="kJ/kg")"enthalpy of the steam before entering the condenser";
Real s7(unit="kJ/kg.K")"entropy of the steam after leaving the turbine";
Real X8(unit="dimensionless")"quality of the steam after leaving the turbine";
Real X9(unit="dimensionless")"quality of the steam after leaving the condenser";
Real h9(unit="kJ/kg")"enthalpy of the steam after leaving the condenser";
Real Y(unit="dimensionless")"quantity of the steam after leaving the finally";
Real n(unit="dimensionless")"Thermal efficiency of the stea power plant";

//=================
//equation section
equation
//Refer to steam table in the appendix in book Pg no:443 for the value of hf1,hg1,sf1,sg1
hf1=191.83;
sf1=0.6493;
hg1=2584.8;
sg1=8.1511;
//Refer to steam table in the appendix in book Pg no:448 for the value of h,s
h=2995.1;
s=6.5422;
//Refer to steam table in the appendix in book Pg no:443 for the value of hf,hg,sf,sg
hf=604.67;
hg=2737.6;
sf=1.7764;
sg=6.8943;
h2=191.83;
h4=604.67;
h7=2995.7;
s7=6.5422;
s7=(X8*sg)+((1-X8)*sf);
h8=(X8*hg)+((1-X8)*hf);
s7=(X9*sg1)+((1-X9)*sf1);
h9=(X9*hg1)+((1-X9)*hf1);
Y=(h4-hf1)/(h8-hf1);
n=((h7-h4)-((1-Y)*(h9-hf1)))/(h-hf);//Refer to book Pg no:344 for the equation
end Ex9_3;
