//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004
  //Chapter 9:Power and Refrigration cylcle
  //Example:9.4
  //Title:Air-standard otto cycle
  //Calculate 1temperature and pressure of terminal points 2thermal eﬃciency 3work done per kg of air 4mean effective pressure
package Ex9_4

model Ex9_4_a

//======================
//parameter section
parameter Real CR(unit="dimensionless")=8"compression ratio";
parameter Real T1(unit="K")=300"Temperature at the beginning of the compresssion stroke";
parameter Real P1(unit="kPa")=100"Presssres at the beginning of the compresssion stroke";
parameter Real q(unit="kJ/kg")=1840"Thermal energy supplied";
parameter Real Cv(unit="kJ/kg.K")=0.7176"specific heat at constant volume";
parameter Real gamma(unit="dimensionless")=1.4"Ratio of specific heat";

//======================
//variable section
Real T2(unit="K")"final temperature in the first isentropic process";
Real P2(unit="kPa")"final pressure in the first isentropic process";
Real T3(unit="K")"final temperature in the constant volume prcess";
Real P3(unit="kPa")"final pressure in the constant volume process";
Real T4(unit="K")"final temperature in the second isentropic process";
Real P4(unit="kPa")"final pressure in the second isentropic process";

//=================
//equation section
equation
T2=T1*(CR^(gamma-1));
P2=P1*(CR^gamma);
q=Cv*(T3-T2);
P3/T3=P2/T2;
T4=T3*((1/CR)^(gamma-1));
P4=P3*((1/CR)^gamma);
end Ex9_4_a;


//=================

model Ex9_4_b
extends Ex9_4_a;

//=================
//variable section
Real n(unit="dimensionless")"thermal efficiency";

//================
//equation section
equation
n=1-((1/CR)^(gamma-1));
end Ex9_4_b;


//=================

model Ex9_4_c
extends Ex9_4_b;

//================
//variable section
Real W(unit="kJ/kg")"work done";

//================
//equation section
equation
W=q*n;
end Ex9_4_c;


//================

model Ex9_4_d
extends Ex9_4_a;
extends Ex9_4_b;
extends Ex9_4_c;

//================
//variable section
Real V1(unit="m^3/kg")"volume in the first process";
Real V2(unit="m^3/kg")"volume in the second process";
Real Pm(unit="kPa")"mean effective pressure";

//================
//constant section
constant Real R(unit="J/mol.K")=8.314"gas constant";

//================
//equation section
equation
V1=(R*(10^3)*T1)/(28.97*10^5);//Assuming number of moles as 1 use ideal gas law
V2=V1/CR;
Pm=W/(V1-V2);
end Ex9_4_d;



end Ex9_4;
