//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004
//Chapter 9:Power and Refrigration cylcle
//Example:9.6
//Title:Air-standard Diesel Cycle
//Calculate 1compression ratio 2cutoﬀ ratio 3thermal efﬁciency 4work done per kg air

package Ex9_6

model Ex9_6_a

//===================
//parameter section
parameter Real T1(unit="K")=323"Temperature at the start of the compression stroke";
parameter Real P1(unit="kPa")=100"Pressure at the start of the compression stroke";
parameter Real P2(unit="MPa")=4"Pressure at the end of the stroke";
parameter Real q1(unit="kJ/kg of air")=600"Energy absorbed";
parameter Real Cp(unit="kJ/kg.K")=1.0047"specific heat at constant pressure";
parameter Real gamma(unit="dimensionless")=1.4"Ratio of specific heat";

//===================
//variable section
Real CR(unit="dimensionless")"Compression ratio";

//===================
//equation section
equation
CR=(P2/(P1/1000))^(1/gamma);
end Ex9_6_a;

//===================

model Ex9_6_b
extends Ex9_6_a;

//===================
//variable section
Real T2(unit="K")"Temperature at the end of the stroke";
Real T3(unit="K")"Temperature at which energy is absorbed";
Real rc(unit="dimensionless")"the cut off ratio";

//===================
//equation section
equation
T2=(P2*T1)/(P1*CR/1000);
q1=Cp*(T3-T2);
rc=T3/T2;
end Ex9_6_b;

//====================

model Ex9_6_c
extends Ex9_6_a;
extends Ex9_6_b;

//===================
//variable section
Real n(unit="dimensionless")"efficiency of the cycle";

//===================
//equation section
equation
n=1-((1/(gamma*(CR^(gamma-1))))*(((rc^gamma)-1)/(rc-1)));
end Ex9_6_c;

//==================

model Ex9_6_d
extends Ex9_6_c;
extends Ex9_6_a;
//==================
//variable section
Real W(unit="kJ/kg")"work done per kg air";

//================
//equation section
equation
W=n*q1;
end Ex9_6_d;
end Ex9_6;
