//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004
//Chapter 9:Power and Refrigration cylcle
//Example:9.7
//Title:Air-standard Diesel Cycle
//Determine 1max temperature of cycle 2cutoﬀ ratio 3energy added as heat 4thermal eﬃciency of cycle

model Ex9_7

//=====================
//parameter section
parameter Real CR(unit="dimensionless")=16"compression ratio";
parameter Real P1(unit="kPa")=100"Pressure at the start of the compression stroke";
parameter Real T1(unit="deg C")=37"Temperature at the start of the compression stroke";
parameter Real delS(unit="kJ/kg.K")=1.2"change in entropy of the air";
parameter Real gamma(unit="dimensionless")=1.4"Ratio of specific heat";
parameter Real Cp(unit="kJ/kg.K")=1.0047"Specific heat at constant pressure";
//parameter Real T2(unit="K")=940.2"Temperature at the end of the compression stroke";
//=====================
//variable section
Real T2(unit="K")"Temperature at the end of the compression stroke";
Real T3(unit="K")"Maximum Temperature of the cycle";
Real rc(unit="dimensionless")"cut-off Ratio";
Real q1(unit="kJ/kg")"energy added as heat";
Real n(unit="dimensionless")"Thermal efficiency of the cycle";

//====================
//equation section
equation

T2=(T1+273.15)*(CR^(gamma-1));
delS=Cp*log(T3/T2);
rc=T3/T2;
q1=Cp*(T3-T2);
n=1-((1/(gamma*(CR^(gamma-1))))*(((rc^gamma)-1)/(rc-1)));
end Ex9_7;
