//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004
//Chapter 9:Power and Refrigration cylcle
//Example:9.9
//Title:Refrigerants
//Calculate 1COP of referigerator 2capacity 3power required 4COP of carnot referigerator

model Ex9_9

//====================
//parameter section
parameter Real Tmin(unit="deg C")=-20"minimum operating Temperature of the Refrigerant";
parameter Real Tmax(unit="deg C")=40"Maximum operating Temperature of the Rerigerant";
parameter Real FR(unit="kg/s")=0.05"Flow rate of the refrigerant";

//====================
//variable section
Real h2(unit="kJ/kg")"enthalpy of the refrigerant at maximum refrigerant temperature";
Real s2(unit="kJ/kg.K")"entropy of the refrigerant at maximum refrigerant temperature";
Real sf(unit="kJ/kg.K")"entropy at the liquid state at maximum refrigerant temperature";
Real sg(unit="kJ/kg.K")"entropy at the vapor state at maximum refrigerant temperature";
Real hf(unit="kJ/kg")"enthalpy at the liquid state at maximum refrigerant temperature";
Real hg(unit="kJ/kg")"enthalpy at the vapor state at maximum refrigerant temperature";
Real X1(unit="dimensionless")"quality of the vapor in the 1-2 isentropic prrocess";
Real h1(unit="kJ/kg")"enthalpy of the vapor in the first stage";
Real h3(unit="kJ/kg")"enthalpy when the refrigerant leaves the condenser";
Real COP(unit="dimensionless")"Coefficient of performance of the refrigerant";
Real CR(unit="kW")"Capacity of the refrigerator";
Real COP1(unit="dimensionless")"coefficient of performance of the carnot refrigerator";

//=================
//equation section
equation

//Refer to book Pg no:370 for the value of h2,h1,hf,hg,sf,sg
h2=203.1063;
s2=0.6825;
sf=0.0736;
sg=0.7094;
hf=17.9517;
hg=178.9017;
s2=(sg*X1)+((1-X1)*sf);//refer to book Pg no:371 for the equation
h1=(hg*X1)+((1-X1)*hf);
h3=75.1134;
COP=(h1-h3)/(h2-h1);
CR=FR*(h1-h3);
COP1=(Tmin+273)/(Tmax-Tmin);
end Ex9_9;
