model Ex1_4
  //Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-1:Basic Concepts And Fluid Properties
  //Example: 1.4 Page 14
  //Title: Pressure difference in a soap water bubble
  //===================================================================
  //parameter section
  parameter Real bubble_dia(unit = "m") = 0.1 "Diameter of soap bubble";
  parameter Real surface_tens(unit = "N/m") = 0.025 "Surface tension of soap bubble";
  
  //variable section
  Real bubble_rad(unit = "m") "Radius of the bubble";
  Real pressure_diff(unit = "N/m2") "Pressure difference in soap water bubble";
  
  //equation section
equation
  bubble_rad = bubble_dia / 2;
  pressure_diff = 2 * surface_tens / bubble_rad;
end Ex1_4;
//===================================================================
