 //Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-1:Basic Concepts And Fluid Properties
  //Example: 1.5 Page 16
  //Title: Rise of water and mercury in a capilliary tube 
 model Ex1_5
 import SI = Modelica.SIunits;
 import Modelica.SIunits.Conversions.*;
 final constant Real pi=2*Modelica.Math.asin(1.0);//the value of pi
//parameter section 
//===================================================================
parameter SI.Length rad_tube=0.001 "radius of tube";
parameter SI.SurfaceTension sigma_water=0.073 "Surface tension of water";
parameter SI.SurfaceTension sigma_hg=0.48 "Surface Tension of mercury";
parameter SI.Density rho_water=1000 "Density of water";
parameter SI.Density rho_hg=13600 "Density of mercury";
parameter SI.Acceleration acc_gravity=9.81 "Accelaration due to gravity";
parameter SI.Angle wet_angle_water=0 "Wetting angle of water";
parameter SI.Angle wet_angle_hg=130*pi/180 "Wetting angle of mercury";

//variable section 
SI.Length h_water;
SI.Length h_hg;

//equation section 
equation
//using eq 1.24 from the textbook
h_water=(2*sigma_water*cos(wet_angle_water*pi/180))/(rho_water*acc_gravity*rad_tube);
h_hg=(2*sigma_hg*cos(wet_angle_hg*pi/180))/(rho_hg*acc_gravity*rad_tube);
end Ex1_5;
//===================================================================
