//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-10:Elements of Inviscid compressible flow
  //Example: 10.2 Page 349
  //Title: Temperature increse in supersonic speeds
  //===================================================================
model Ex10_2
import SI=Modelica.SIunits;

//parameter section
parameter Real t0(unit = "K")=850 "The maximum temperature that the plane can withstand";
parameter Real t(unit = "K")=270 "The ambiient temperature";
parameter Real x=1.4 "The ratio of specific heat of air";
parameter Real t01(unit = "K")=2500 "The temperature of the combustion products";

//variable section
Real m "The mach number at stagnation temperature";
Real m2 "The mach number at which the air heats up to the temperature of combustion products";

//equation section
equation
//by using Equation 10.21
m=(2/(x-1)*((t0/t)-1))^0.5;
m2=(2/(x-1)*((t01/t)-1))^0.5;
end Ex10_2;
//variation: m=3.277 through simulation 
//           m=3.28 as given in the book
//===================================================================
