//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-11:Fluid Machinery
  //Example: 11.1 Page 386
  //Title: Simple axial fan
  //===================================================================
model Ex11_1
import SI = Modelica.SIunits;
final constant Real pi = 2 * Modelica.Math.asin(1.0);//the value of pi

//parameter section
SI.Length r_av=0.3 "The average radius of the rotor";
parameter Real rpm(unit = "RPM")=3000 "The angular speed of the fan";
SI.Velocity v_ax=61 "The axial velocity of the fan";

//variable section
SI.Velocity u "The blade velocity";
Real a1(unit = "degree") "The swirl";
SI.Velocity c1 "for velcoity diagram construction";
Real b1(unit = "degree") "The incoming relative angle";
Real b2(unit = "degree") "The angle at which flow leaves";
SI.Velocity w1 "The tangential velocity";
SI.Velocity w2 "The tangential velocity";
SI.Velocity del_c "The change in tangential velocity";

//equation section
equation
u=2*pi*r_av*rpm/60;//the blade velocity
//since there is no turning vane , the incoming flow is assumed to have no swirl
a1=0;
//velocity triangle is drawn with the information available. fig 11.13
//from the figure 11.13 c1=v_ax
c1=v_ax;
b1=Modelica.Math.atan(u/v_ax)*180/pi;//the incoming relative angle
//since the blade is oriented 45 deg , the angle of attack is 17 deg which is workable
//assuming the flow is attached 
b2=45;
w2=v_ax;//since of b2= 45 degree
w1=u;
del_c=w1-w2;//change in tangential velocity
end Ex11_1;
//===================================================================
