//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-11:Fluid Machinery
  //Example: 11.6 Page 409
  //Title: The compression ratio of a centrifugal compressor
  //===================================================================
model Ex11_6
import SI=Modelica.SIunits;
final constant Real pi=2*Modelica.Math.asin(1.0);//the value of pi

//parameter section
parameter Real w(unit = "RPM")=5000 "The rotation speed of the compressor";
parameter SI.Length r1=0.2 "The impeller dimension";
parameter SI.Length r2=0.4 "The impeller dimension";
parameter Real b(unit = "Degree")=15 "The blade angle";
parameter Real nc=0.9 "The stage efficiency";
parameter Real x=1.4 "The ratio of specific heats";
parameter Real t01(unit = "K")=300 "The air temperature";
parameter Real cp(unit = "kCal/(kg Celcius)")=0.24 "The specific heat";

//varaible section 
Real cp_j(unit = "J/(kg celcius)") "The specific heat in joules";
Real w_rps(unit = "rps") "The rotation speed in rps";
SI.Velocity u2 "The blade tip velocity at station 2";
SI.Velocity wr2 "The exit radial velocity";
SI.Velocity c02 "The exit tangential velocity";
Real t_ratio "The stagnation temperature rise"; 
Real p_ratio "The pressure rise";

//equation section
equation
//the exit velocity diagram must be constructed as shown in figure 11.31
//the blade tip velocity at station 2
w_rps=w/60;
u2=2*pi*r2*w_rps;
//we make the assumption that wr2=u2/2 as given in the question
wr2=u2/2;
//the exit tangential velocity is calculated based on the velocity triangle
c02=wr2*tan(b*pi/180) +u2;
//the stagnation temoerature rise is calculated from equation 11.55
cp_j=cp*4200;
t_ratio=(u2*c02-0)/(cp_j*t01);
//the pressure rise is calculated using equation 11.53
p_ratio=(1+nc*t_ratio)^(x/(x-1));
end Ex11_6;
//===================================================================
