 //Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-3:Fluid Statics
  //Example: 3.2 Page 83
  //Title: Hydrostatic force on a circular valve
  //===================================================================
model Ex3_2
import SI=Modelica.SIunits;
import Modelica.SIunits.Conversions.*;
//From the figure 3.19 the wall inclination is 60 and the depth is 10m. the diameter of the circulart valve is 4m

//parameter section
final Real pi=2*Modelica.Math.asin(1);
parameter SI.Radius valve_rad=2 "Radius of circular valve";
parameter SI.Density rho_water=1000 "Density of water";
parameter SI.Acceleration g=9.8 "Acceleration due to gravity";
parameter SI.Length h=10 "Depth of the centre of valve";

//variable section
SI.Area s "Area of the circular valve";
Real p(unit = "N/m2") "Pressure at the centroid";
SI.Force fz "Force acting on the circular valve";
SI.Length Xcp "The x component of centre of pressure";
SI.Length Ycp "The y component of centre of pressure";
SI.Length y "The y component of centroid";
Real Ixx(unit = "m4") "The moment of inertia along horizontal passing through centroid";
Real M(unit = "Nm")"The opening moment";

//equation section
equation
s=pi*valve_rad^2;
p=rho_water*g*h;
fz=-p*s;//minus sign indicates the normal force is pushing the valve in -z direction
//From the diagram 3.19 Xcp=h. there is no change in x direction because of lateral symmetry
Xcp=h;
y=h/sin(pi/3);//using the trigonometric relations
Ixx=pi*(valve_rad^4)/4;
Ycp=(Ixx/(y*s))+y;
M=fz*(Ycp-y);

end Ex3_2;
//what to do with negative sign in M
//===================================================================

