//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-3:Fluid Statics
  //Example: 3.5 Page 90
  //Title: Hot-air Balloon
  //===================================================================
model Ex3_5
import SI=Modelica.SIunits;
final Real pi=2*Modelica.Math.asin(1.0);

//parameter section
SI.Mass m=275 "The assumption that hot air balloon's structural weight including passengers";
parameter Real t(unit = "K")=290 "The ambient temperature";
parameter Real rho_air(unit = "kg/m3")=1.22 "The density of air";
SI.Length d=15 "The diameter of the sphere";
SI.Acceleration g=9.81 "The acceleration due to gravity";

//variable section
SI.Force l "The buoyancy which causes the lift";
Real t_ratio "The temperature ratio of cold to hot";
Real t_hot(unit = "K") "The temperature of the hot air";
Real t_hot_deg(unit = "Degree")"The hot air in Degree";

//equation section
equation
//based on eq3.48
//l=rho_cold*g*v - rho_hot*g*v
//where rho_cold is density of normal air.
//using eq1.8  p/(rho_cold * t_cold) = p/(rho_hot * t_hot)
//therefore rho-cold*t_cold = rho_hot*t_hot
//the lift is equal to the weight of the balloon
l=m*g;
t_ratio=1-(6*m*g/(rho_air*g*pi*d^3));
t_hot=t/t_ratio;
t_hot_deg=t_hot-273;
//the temperature is quite hot but not hot enough to burn hole in the fabric
end Ex3_5;
//===================================================================
