 //Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-1:Introduction to fluid in motion-one dimensional flow
  //Example: 4.1 Page 115
  //Title: Force on a turbine blade 
  //===================================================================
model Ex4_1
import SI =Modelica.SIunits;
import Modelica.SIunits.Conversions.*;

//parameter section
parameter SI.Area a=from_cm2(1) "The nozzle area";
parameter SI.Velocity un=15 "The water velocity at nozzle";
parameter SI.Velocity ub=10 "The blade velocity";
final Real pi=2*Modelica.Math.asin(1);
parameter SI.Density rho_water=1000 "The density of water";

//Variable section
//From the figure 4.5 Station 1 and 2 are seen. The angle of inclination of blade is 120 degree
SI.Velocity u1 "The relative velocity of water at station 1";
SI.Velocity u2 "The relative velocity of water at station 2";
SI.Force fx "The force along the x direction";
SI.Force fz "The force along the z direction";
SI.Power w "The power generated by the blade";

//equation section
equation
u1=un-ub;
u2=un-ub;
fx=rho_water*(u1^2)*a*(cos(2*pi/3)-1);
fz=rho_water*(u1^2)*a*sin(2*pi/3);
//from the figure 4.5 the force in the x direction i negative, indicating the force
//acting on the control volume. The fluifd is pushing the blade to right and the z component is pushing the blade down.
w=-1*fx*ub;
end Ex4_1;
//===================================================================
