//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-5: Incompressible flow:Exact solutions
  //Example: 5.12 Page 178
  //Title: Parallel flow in two pipes
  //===================================================================
  
model Ex5_12
import SI=Modelica.SIunits;

//parameter section 
parameter Real q(unit = "m3/s")=0.005 "The flow rate of water";
parameter SI.Length l=10"The length of the pipe";
parameter SI.Length d=0.05 "The diameter of the pipe before splitting into two";
parameter SI.Length d1=0.03 "The diameter of the upper pipe";
parameter SI.Length l1=12 "The total length of the upper pipe";
parameter Real k1=0.9 "The entrance/exit losses";
parameter Real k2=0.2 "The loss coefficients in the two bends";
parameter Real f=0.025 "The internal friction factor for both the pipes";
final constant Real pi=2*Modelica.Math.asin(1.0);//the value of pi

//variable section
SI.Velocity u_up "The velocity in the upper pipe";
SI.Velocity u_low "The velocity in the lower pipe";
Real x "The ratio of u_up/u_low";
SI.Area s_low "The cross sectional area of lower pipe";
SI.Area s_up "The cross sectional area of upper pipe";
Real ql(unit = "m3/s") "The flow rate in the lower section of the pipe";
Real ql_lps(unit = "L/s")"The flow rate in litres per second";

//equation section
equation
//calculating the head loss in upper pipe 
//h_upper=((f*l1/d1)+2*k1+2*k2)u_up^2/(2*g);
//calculating the head loss in lower pipe
//h_lower=f*l*u_low^2/(2*g*d);
//equating the head losses in the upper and lower pipes we get the ratio of u_up/u_low
//this is because the pressure drop is the same accross both points.
//let me assume this ratio as x=u_up/u_low;
x=((f*l/d)/((f*l1/d1)+2*k1+2*k2))^0.5;
s_low=pi*d*d/4;
s_up=pi*d1*d1/4;
//the incoming flow rate is equal to flow rate in upper pipe+ flow rate in lower pipe
//s_low*u_low + s_up*u_up = q
//as we know that u_up=x*u_low, we substitute the same in the equation to find u_low
u_low=q/(s_low+s_up*x);
u_up=x*u_low;
ql=s_low*u_low;
ql_lps=ql*1000;//the flow rate in litres per second
end Ex5_12;
//Note the flow rate in the lower pipe QL mentioned in the book is defined as ql_lps in the code.
//===================================================================
