//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-5:Viscous Incompressible flow:Exact solutions
  //Example: 5.3 Page 151
  //Title: Water flow due to pressure gradient between parallel plates
  //===================================================================
model Ex5_3
import SI=Modelica.SIunits;
import Modelica.SIunits.conversions.*;
parameter SI.Velocity u_av=1 "The average velocity of water flow ";
parameter SI.Length h=0.01 "The clearance height between plates";
parameter SI.DynamicViscosity mu_water=0.001 "The viscoisty of water obtained from Table 1.1 in the book ";
parameter Real rho_water(unit = "kg/m3")=1000 "The density of water";
//From the relation obtained between maximum velocity and average velocity in page number 149 Eq.5.34 
//We come to know that u_max=1.5u_av

//variable section
SI.Velocity u_max "The maximum velocity of the water flow";
Real cf "The coefficient of friction";
Real der_p(unit = "Pa/m") "The pressure";
SI.ShearStress t_xz "The shear stress due to the flow";
Real re "The reynolds number";

//equation section
equation
u_max=1.5*u_av;
der_p=-12*mu_water*u_av/(h*h);
//from equation 5.35
t_xz=-h/2*der_p;
re=rho_water*u_av*h/mu_water;
cf=12/re;
end Ex5_3;

//===================================================================

