//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-5:Viscous Incompressible flow:Exact solutions
  //Example: 5.9 Page 173
  //Title: Laminar flow in a vertical pipe
  //===================================================================
model Ex5_9
import SI=Modelica.SIunits;
import Modelica.SIunits.Conversions.*;

//parameter section
parameter SI.Length h_tube=0.2 "The height of circular tube";
parameter SI.Length h_liquid=0.1 "The liquid height in the container";
parameter Real rho_gly (unit = "kg/m3")=1254 "The density of glycerine";
parameter Real mu_gly (unit = "Ns/m2")=0.62"The dynamic viscosity of glycerine";
parameter SI.Length d=0.01 "The diameter of the pipe";
parameter SI.Acceleration g=9.8 "The acceleration due to gravity";

//variable section
SI.Velocity u2 "The discharge velocity ";
SI.Velocity u2_1 "The discharge velocity solution 1";
SI.Velocity u2_2 "The discharge velocity solution 2";
Real a "The coefficient of u2^2";
Real b "The coefficient of u2";
Real c "The constant in discharge velocity quadratic equation";
Real Re "The reynolds number for the flow";
SI.Length tot_h "The total vertical height from the base";

//equation section
equation
tot_h=h_tube+h_liquid;
//Applying Bernoulli"s equation to the pipe section
//tot_h+  (p1/(rho_gly*g))+  0= (p1/(rho_gly*g))+ u2^2/(2*g)+ hf; *Here p1 is the pressure*
//the hf can be rewritten by substituting f=64/Re and Re=rho_gly*u2*d/mu_gly;
//the Bernoulli equation will then become a quadratic equation in u2
//(a*u2^2)+ (b* u2)=c where a, b and c are defined correspondingly with the benoulli's equation;
a=(2*g)^(-1);
b=32*mu_gly*h_tube/(rho_gly*d*d*9.8);
c=-1*tot_h;
u2_1=(-b+(b*b-4*a*c)^0.5)/(2*a);
u2_2=(-b-(b*b-4*a*c)^0.5)/(2*a);
//Velocity should be a positive value. Hence the u2 values have to be checked for this condition 
if u2_1>0 then
u2=u2_1;
else 
u2=u2_2;
end if;
Re=rho_gly*u2*d/mu_gly;
end Ex5_9;
//Error in the calculation of quadratic equation for u2 in the book
//the calculated values of a, b, c are a=0.05102, b=3.225, c=-0.3
//solving the quadratic equation, the two roots are
//u2_1=0.09277 m/s and u2_2=-63.378 m/s 
//since u2_2 is negative it is eliminated and u2=0.09277 m/s
// this value is wrongly printed as u2=0.93 m/s
//Since u2 is incorrect, Re is also incorrect
//incorrect Re=18.8
//calculated Re=1.8764 (this value is obtained when u2=0.09277 m/s) 
//Since Re is much less than 2100 when calculated, the flow is laminar. 
//===================================================================
