//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-7:The (Laminar)Boundary Layer
  //Example: 7.1 Page 240
  //Title: Skin friction drag of a flat plate
  //===================================================================
model Ex7_1
import SI=Modelica.SIunits;

//parameter section
parameter SI.Length b=1 "The width of the plate";
parameter SI.Length l=0.5 "The length of the plate";
parameter SI.Velocity u=2 "The velocity of the water in the tank";
parameter Real rho_l(unit = "kg/m3")=1000 "The density of the liquid";
parameter Real mu_l(unit = "Ns/m2")=0.001 "The dynamic viscosity of the liquid";

//variable section
Real Re "The reynolds number for the flow";
Real cd "The discharge coefficient";
SI.Force d "The total drag";
SI.Length bl "The boundary layer thickness";
SI.Length theta "The momentum thickness";
Real theta_mm(unit = "mm") "The momentum thickness in millimetres";
Real Re1 "Thereynolds number of the flow when the plate is turned";
Real cd1 "The discharge coefficient when the plate is turned";
SI.Force d1 "The total drag when the plate is turned";
SI.Length bl1 "The boundary layer thickness when the plate is turned";
SI.Length theta1 "The momentum thickness when the plate is turned";
Real theta1_mm(unit = "mm") "The momentum thickness in millimetres when the plate is turned";

//equation section
equation
//since it is given in the question to assume laminar flow we use blasius equation
Re=rho_l*u*l/mu_l;
cd=2*0.664/(Re)^0.5;
//The total drag on the two sides is given by
d=2*cd*0.5*rho_l*u*u*l*b;
//The boundary layer thickness is caalculated as 
bl=1.721/(Re)^0.5*l;
theta=0.664*l/(Re)^0.5;
theta_mm=theta*1000;
//Now the same calcuclations are done with the plate turned by 90 degrees
Re1=rho_l*u*b/mu_l;
cd1=2*0.664/(Re1)^0.5;
//The total drag on the two sides is given by
d1=2*cd1*0.5*rho_l*u*u*l*b;
//The boundary layer thickness is caalculated as 
bl1=1.721/(Re1)^0.5*l;
theta1=0.664*b/(Re1)^0.5;
theta1_mm=theta1*1000;
end Ex7_1;
//===================================================================
