//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-7:The (Laminar)Boundary Layer
  //Example: 7.2 Page 241
  //Title: Turbulent drag of a flat plate
  //===================================================================
model Ex7_2
import SI=Modelica.SIunits;

//parameter section
parameter SI.Velocity u=12 "The velocity of wind";
parameter SI.Length b=4 "The width of the roof";
parameter SI.Length l=10 "The length of the roof";
parameter Real rho_air(unit = "kg/m3")=1.22 "The density of air";
parameter Real mu_air(unit = "Ns/m2")=1.8*10^(-5) "The dynamic viscosity of air";

//variable section
Real Re "The reynolds number for the flow over roof";
Real cd "The drag coefficient";
SI.Force d "The total drag force";

//equation section
equation
//the question assumes the flow to be turbulent
Re=rho_air*u*b/mu_air;
//Since we assume a turbulent flow the drag coefficient per side is 0.0032  from the figure7.10
cd=0.0032;
//the total drag is calculated as
d=2*cd*0.5*rho_air*u*u*b*l;
end Ex7_2;
//===================================================================
