//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-8:High Reynolds Number flow over Bodies (Incompressible)
  //Example: 8.11 Page 286
  //Title: Hydrodynamic drag
  //===================================================================
model Ex8_11
import SI=Modelica.SIunits;

//parameter section
parameter SI.Velocity u=20/3.6 "The velocity of submarine";
parameter Real cd=0.15 "The drag coefficient based on frontal area";
parameter SI.Area s=4 "The frontal area of the submarine";
parameter Real rho_sea(unit = "kg/m3")=1025 "The density of sea water";

//variable section
SI.Force d "The total drag on the submarine";
SI.Power p "The total power required";
Real p_kW(unit = "kW") "The power in kiloWatts";
Real p_hp(unit = "hp")"The power in horse power";

//equation section
equation
d=cd*0.5*rho_sea*u*u*s;
p=d*u;
p_kW=p/1000;//power in kilowatts
p_hp=p/745.6;//power in horse power
end Ex8_11;
//variation: power=52.7 kW in the book
//           power=52.7263 kW in simulatuion
//           p_hp=71 hp in book
//           p_hp=70.79 hp in simulation
//===================================================================
