//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-8:High Reynolds Number flow over Bodies (Incompressible)
  //Example: 8.15 Page 289
  //Title:Flow oscillation behind a large truck
  //===================================================================
model Ex8_15
import SI=Modelica.SIunits;

//parameter section
parameter SI.Velocity u=100/3.6 "The velocity of the wind";
parameter SI.Length d=2 "The width of the truck";
parameter Real rho_air(unit = "kg/m3")=1.2 "The density of air";
parameter Real mu_air(unit = "Ns/m2")=1.81*10^(-5) "The dynamic viscosity of air";

//variable section
Real Re "The reynolds number for the flow";
Real f(unit = "Hz")"The oscillating frequency of the shredding";
Real st "The strouhal number";
SI.Length l "The distance between the two cycles";

//equation section
equation
Re=rho_air*u*d/mu_air;
//using the same strouhal number
st=0.23;
f=st*u/d; 
l=u/f;
end Ex8_15;
//===================================================================
