//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-8:Two dimensional elementary solutions
  //Example: 8.2 Page 268
  //Title: Velocity induced by a doublet
  
model Ex8_2
import SI=Modelica.SIunits;
final constant Real pi=2*Modelica.Math.asin(1);//the value of pi

//parameter section
parameter Real q(unit = "m3/s")=1 "The strength at the given cartesian coordinate";
parameter Real x=1 "The x coordinate at which the velocity has to be found";
parameter Real z=0 "The z coordinate at which the velocity has to be found";
parameter Real x0=0 "The x coordinate of origin";
parameter Real z0=0 "The z coordinate of the origin";
parameter Real x1=1 "The x coordinate at which the velocity has to be found";
parameter Real z1=1 "The z coordinate at which the velocity has to be found";

//variable section
SI.Velocity u;
SI.Velocity w;
//u and w are the velocity components at that point
SI.Velocity u1;
SI.Velocity w1;
//the velocity components at the point(1,1)
SI.Length r "The value of the distance between two points";
SI.Length r1 "The value of the distance between two points";

//equation section
equation
r=((x-x0)^2+(z-z0)^2)^0.5;
u=q/(2*pi)*((x-x0)^2-(z-z0)^2)/(r)^4;
w=q/(2*pi)*(2*(x-x0)*(z-z0))/(r)^4;
//suppose we want to find the velocity at a point x=1 and z=1 then 
r1=((x1-x0)^2+(z1-z0)^2)^0.5;
u1=q/(2*pi)*((x1-x0)^2-(z1-z0)^2)/(r1)^4;
w1=q/(2*pi)*(2*(x1-x0)*(z1-z0))/(r1)^4;
//this result verifies the expected direction of the velocity vector
end Ex8_2;
//===================================================================
