//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-8:High Reynolds Number flow over Bodies (Incompressible)
  //Example: 8.21 Page 309
  //Title: Wing trailing vortices
  //===================================================================
model Ex8_21
import SI=Modelica.SIunits;
final constant Real pi=2*Modelica.Math.asin(1.0);//the value of pi

//parameter section
parameter SI.Mass m=100*1000 "The mass of the aeroplane is 100 tons as given";
parameter Real rho_air(unit = "kg/m3")=1.22 "The density of air";
parameter SI.Velocity v=200/3.6 "The velocity of the aeroplane in metres per second";
parameter SI.Length b=47 "The wingspan as mentioned in figure 8.49";
parameter SI.Acceleration g=9.8 "The acceleration due to gravity";

//variable section
SI.Force f "The weight of the plane";
Real t(unit = "m2/s") "The circulation per unit length based on the lift";
SI.Velocity w_ms "The downwash at point A in metres per second(Based on eq 8.50)";
Real w_kmh(unit = "km/h") "The downwash at point A in kilometeres per hour";

//equation section
equation
f=m*g;
//the kutta-joukowski theorem of equation 8.87 determines the circulation per unit length
t=f/(rho_air*v*b);
w_ms=2*t/(2*pi*b/2);
w_kmh=w_ms*3.6;
//this could be significant for a small plane
end Ex8_21;
//===================================================================
//Error in the book: the formula for downwash is given properly but while substitution there is an error.
//division of the wingspan(b in the code) by 2 is not done. hence there is a change in value of w_ms from 8.33 m/s to 4.167 m/s 
//and w_kmh from 30 kmph to 15 kmph
