//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-8:High Reynolds Number flow over Bodies (Incompressible)
  //Example: 8.25 Page 313
  //Title: Lift of a slender wing
model Ex8_25
import SI=Modelica.SIunits;
final constant Real pi=2*Modelica.Math.asin(1.0);//the value of pi

//parameter section
parameter SI.Length b=15 "The wing span";
parameter SI.Acceleration g=9.8 "The acceleration due to gravity";
parameter SI.Length c=25 "The chord length of the wing";
parameter SI.Velocity u=70 "The the landing speed of the plane";
parameter Real rho_air(unit = "kg/m3")=1.2 "The density of the air";

//variable section
Real ar "The aspect ratio of the slender wing";
Real cl "The coefficient of lift";
SI.Force f "The weight of the aeroplane";
SI.Force d "The drag caluclated with equation 8.106";

//equation section
equation
ar=b*b/(0.5*b*c);
cl=(0.963+(1.512*ar))*sin(20*pi/180);
f=cl*0.5*rho_air*u*u*(b*c*0.5);
d=f*tan(20*pi/180);
end Ex8_25;
//===================================================================
//Deviation from the value: since cl =0.9499 instead of 0.95 as given in the book,
//f becomes 523647N instead of 523687.5N and d becomes 190592N instead of 190606N
