//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-8:Two dimensional elementary solutions
  //Example: 8.3 Page 270
  //Title: Velocity induced by a vortex
  //===================================================================
model Ex8_3
import SI=Modelica.SIunits;
final constant Real pi=2*Modelica.Math.asin(1.0);//the value of pi

//parameter section
parameter Real q(unit = "m3/s")=5 "The cic=rculation of the vertex";
parameter Real x0=1 "The x coordinate at which the circulation is known";
parameter Real z0=1 "The z coordinate at which the circulation is known";
parameter Real x=0 "The x coordinate at which the velocity has to be found";
parameter Real z=-1 "The z coordinate at which the velocity has to be found";
parameter Real x1=3 "The x coordinate at which the velocity has to be found";
parameter Real z1=0 "The z coordinate at which the velocity has to be found";

//variable section
SI.Velocity u;
SI.Velocity w;
//u and w are the velocity components at (x,z)
SI.Velocity u1;
SI.Velocity w1;
//u1 and w1 are the velocity components at (x1,z1)
SI.Length r "The length of the vector between two points";
SI.Length r1 "The length of the vector between two points";

//equation section
equation
//using velocity equation for the vortex , for the first point
r=((x-x0)^2+(z-z0)^2)^0.5;
u=q/(2*pi)*(z-z0)/(r)^2;
w=-q/(2*pi)*(x-x0)/(r)^2;
//for the second point
r1=((x1-x0)^2+(z1-z0)^2)^0.5;
u1=q/(2*pi)*(z1-z0)/(r1)^2;
w1=-q/(2*pi)*(x1-x0)/(r1)^2;
end Ex8_3;
