//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-8:High Reynolds Number flow over Bodies (Incompressible)
  //Example: 8.1 Page 265
  //Title: Flow normal to a 2D flat plate
  //===================================================================
model Ex8_9
import SI=Modelica.SIunits;

//parameter section
parameter Real rho_air(unit = "kg/m3")=1.2 "The density of air";
parameter SI.Length l=1 "The length of the plate";
parameter SI.Length b=1 "The breadth of the plate";
parameter SI.Velocity u=15/3.6 "The velocity of wind in m/s";

//variable section 
SI.Force d "The total drag force";
Real cd "The total drag cofficient";

//equation section
equation
//drag force = pressure difference between front and back of the plate * surface area of the plate
//p_front-p_infinity= c_front*0.5*rho_air*u*u*l*b
//p_rear-p_infinity=c_rear*0.5*rho_air*u*u*l*b;
//therefore d=(p_front-p_rear)*l*b=(c_front-c_rear)*0.5*rho_air*u*u*l*b;
//Now based on figure 8.22 the average quantity of c_rear is about 1.1
//the average quantity of c_front is abot 0.1
//the cd=1.2=c_front+c_rear
cd=1.2;
d=cd*0.5*rho_air*u*u*l*b;
end Ex8_9;
//===================================================================
