 //Joseph Katz, Introductory Fluid Mechanics, Cambridge University APress, 2010
  //Chapter-1:Basic Concepts And Fluid Properties
  //Example: 1.6 Page 16
  //Title: Compressibility of a liquid
  //===================================================================

model Ex1_6
import SI=Modelica.SIunits;

//parameter section 
parameter SI.Density rho_water=1000 "Density of water";
parameter SI.Acceleration g=9.8 "Acceleration due to gravity";
//assuming the pressure is measured at a depth of 1000m
parameter SI.Length depth=1000 "Depth of seawater";
parameter SI.ModulusOfElasticity e=2.34*10^9 "Modulus of elasticity";

//variable section 
Real change_in_vol "Change in volume";
SI.Pressure change_in_pres "Chnage in pressure";

//equation section
equation
change_in_pres=rho_water*g*depth;
change_in_vol=change_in_pres/e;
end Ex1_6;
//===================================================================

