//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-10:Elements of Inviscid compressible flow
  //Example: 10.1 Page 345
  //Title: Speed of sound in air
  //===================================================================
model Ex10_1
import SI=Modelica.SIunits;

//parameter section
parameter Real r(unit = "m2/(s2K)")=286.6 "The gas constant";
parameter Real t(unit = "K")=300 "The temperature of air";
parameter Real x=1.4 "The specific heat ratio";

//variable section
SI.Velocity a "The speed of sound in air";

//equation section
equation
//from the equation 1.13 we find the speed of sound in air
a=(x*r*t)^0.5;
end Ex10_1;
//===================================================================
