//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-10:Elements of Inviscid compressible flow
  //Example: 10.3 Page 349
  //Title:Pressure and temperature ratio at M=1
  //===================================================================
model Ex10_3

//parameter section
parameter Real t(unit = "K")=300 "The temperature of the compressed air in the tank";
parameter Real p(unit = "atm")=4 "The pressure of the compressed air";
parameter Real m=1 "The Mach number";
parameter Real x=1.4 "The ratio of specific heat";

//variable section
Real t_ratio "The temperature ratio";
Real p_ratio "The pressure ratio";
Real p0(unit = "atm")"The pressure at that temperature";
Real t0(unit = "K")"The temperature";

//equation section
equation
//using eq 10.22 and 10.23 we get
t_ratio=1+((x-1)*m*m*0.5);
p_ratio=(1+((x-1)*0.5*m))^(x/(x-1));
p0=p/p_ratio;
t0=t/t_ratio;
//the pressure ratio is sufficient to accelarate the flow to sonic velocity
end Ex10_3;
