//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-11:Fluid Machinery
  //Example: 11.5 Page 401
  //Title: 50 percent degree-of-reaction compressor
  
model Ex11_5
import SI=Modelica.SIunits;
final constant Real pi=2*Modelica.Math.asin(1.0);//the value of pi

//parameter section
parameter Real R=0.5 "The degree of reaction";
parameter SI.Velocity c1=150 "The velocity leaving the stator ahead of this stage";
parameter SI.Velocity u=290 "The rotor blade velocity at average radius";
parameter Real b2(unit = "Degree")=37 "The angle behind the rotor";
parameter Real t01(unit = "K")=280 "The air temperature";
parameter Real x=1.4 "The ratio of specifc heats";
parameter Real nc=0.85 "The stage efficiency";
parameter Real cp(unit = "kCal/(kg Celcius)")=0.24 "The specific heat";

//variable section
Real a(unit = "Degree") "The incoming velocity angle";
SI.Velocity c01 "The first tangential velocity";
SI.Velocity del_c "The change in tangential velocity";
Real b1(unit = "Degree") "The first blade angle";
Real cp_j(unit = "J/(kg Celcius)") "The specific heat in Joules";
Real Cp "The pressure rise coefficient";
Real p_ratio "The compression ratio";

//equation section
equation
//for a 50 percent degree-of-reaction compressor according to equation 11.45
a=b2;
//because the b2 is exit velocity the velocity triangle can be drawn and the rotor and stator blades airfoil shapes are same from fluid dynamic point of view.since velocity diagram is drawn , change in tangential velocity is calculated geometrically
//refer figure 11.24 for the detailed diagram
c01=c1*sin(a*pi/180);
del_c=u-2*c1*sin(a*pi/180);
//b1 is needed to calculate Cp the pressure rise coefficient
b1=Modelica.Math.atan((u-c01)/(c1*cos(a*pi/180)))*180/pi;
Cp=1-(cos(b1*pi/180)/cos(b2*pi/180))^2;
cp_j=cp*4200;
p_ratio=(1+((nc*u*del_c)/(cp_j*t01)))^(x/(x-1));
end Ex11_5;
//variation:p_ratio=1.38 according to book
//          p_ratio=1.3765 through simulation
//===================================================================
