//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-11:Fluid Machinery
  //Example: 11.9 Page 417
  //Title: Multistage axial turbine
  //===================================================================
model Ex11_9
import SI=Modelica.SIunits;
final constant Real pi=2*Modelica.Math.asin(1.0);//the value of pi

//parameter section
parameter SI.Length r=0.3 "The average radius of the second stage in a multistage axial turbine";
parameter Real w(unit = "RPM")=7000 "The rotation speed of the turbine";
parameter Real t01(unit = "K")=1200 "The temperature of the hot flow gases";
parameter Real rho(unit = "kg/m3")=0.5 "The density of the flow gases";
parameter Real b2(unit = "Degree")=30 "The rotor inflow angle";
parameter Real b3(unit = "Degree")=60 "The exit angle";
parameter Real n=0.9 "The efficiency of the turbine";
parameter Real x=1.4 "The ratio of specific heats";
parameter Real cp(unit = "kCal/(kg Celcius)")=0.24 "The specific heat";

//variable section
SI.Velocity u "The local blade speed";
Real w_rps(unit = "rps") "The rotation speed in rps";
Real cp_j "The specific heat in joule";
SI.Velocity w2 "The tangential component of w02";
SI.Velocity c2 "The axial component cz";
SI.Velocity del_c "The change in tangential velocity";
Real wt(unit = "m2/s2") "velocity component";
Real t_ratio "The temperature drop";
Real p_ratio "The pressure ratio";

//equation section 
equation
w_rps=w/60;
u=r*2*pi*w_rps;
cp_j=cp*4200;
//using the symmetry of the velocity triangle in figure 11.37 we conclude that a2=|b3|=60
//we draw the velocity triangle t the station 2 and station 3 i.e. at the turbine exit by symmetry principle
//we write the tangential component w02
//u-(c2*sin(b3))=w2*sin(b2)--->1
//for the axial component cz 
//c2*cos(b3)=w2*cos(b2) --->2
//solving these two equations we get c2 and w2 
w2=u/2;
c2=0.866*u;
//the change in tangential velocity is therefore
del_c=u-(2*w2*sin(b2*pi/180));
//the power of the turbine is calculated with equation 11.73
wt=u*del_c;
//the temperature drop is calculated with equation 11.93
t_ratio=u*del_c/(cp_j*t01);
p_ratio=(1-t_ratio/n)^(x/(x-1));
end Ex11_9;
//===================================================================
