//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010

//Chapter-1:The Fluid Dynamic Equation
//Example: 2.4 Page 44
//Title: Force on the water pipe
//===================================================================

model Ex2_4
//parameter section 
parameter Real rho_water(unit = "kg/m3")=1000 "Density of water";
//Assuming exit velocity and Area of the exit section
parameter Real exit_velocity(unit = "m/s")=5 "Exit velocity of water";
parameter Real exit_area(unit = "m2")=0.002 "Exit area of the pipe";

//variable section
Real pipe_force(unit = "N") "Exit force of the pipe";

//equation section
equation
pipe_force=rho_water*(exit_velocity)^2*exit_area;
end Ex2_4;
//===================================================================
