 //Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-3:Fluid Statics
  //Example: 3.3 Page 84
  //Title: Hydrostatic Force on a Triangular Surface
  //===================================================================
model Ex3_3
import SI=Modelica.SIunits;
import Modelica.SIunits.Conversions.*;

//parameter section
//From the figure 3.21  we know that the apex is at 5m anfd the triangle
//base is at 11m, with a surface inclination of 30.
parameter SI.Length h=5 "Depth of the base of triangle from surface";
parameter SI.Density rho_water=1000 "Density of water";
parameter SI.Acceleration g=9.8 "Acceleration due to gravity";
final Real pi=2*Modelica.Math.asin(1); 

//variable section
SI.Length Hcen "The depth of centroid from the surface";
Real p(unit = "N/m2") "Hyrdostatic pressure";
SI.Length b "Base of the submergeed triangle";
SI.Length l "Height of the submerged triangle";
SI.Force fz "The force on the triangle surface";
SI.Area s "The area of the triangle";
SI.Length r "Distance between the vertex in triangle";
Real Ixx(unit = "m4") "moment of inertia of triangle along horizontal";
Real Ixy(unit = "m4")"Moment of inertia of triangle";
SI.Length Xcp "X component of centre of pressure";
SI.Length Ycp "Y component of centre of pressure";
SI.Length y "centroid component";

//equation section
equation
Hcen=h+8*sin(pi/6);//The 8sin60 is obtained from trigonometry from the diagram 3.21
p=rho_water*g*Hcen;
b=6;
l=12;
s=0.5*b*l;//area of the triangle
r=6;
fz=-p*s;
Ixx=b*(l^3)/36;
Ixy=b*(b-2*r)*(l^2)/72;
y=Hcen/(sin(pi/6));
Xcp=Ixy/(y*s);
Ycp=Ixx/(y*s);
end Ex3_3;
//===================================================================

