//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-3:Fluid Statics
  //Example: 3.4 Page 90
  //Title: The King's Crown
  //===================================================================
model Ex3_4
import SI=Modelica.SIunits;

//parameter section
SI.Force f=20.9 "The force to hold the crown in position";
parameter Real vc_cc(unit = "cm3")=310 "The volume of water displaced by submerging the crown in cm3";
SI.Acceleration g=9.81 "The acceleration due to gravity";
parameter Real rho(unit = "kg/m3")=1000 "The density of water";

//varaible section
SI.Force w "The weight of the crown";
Real rho_c(unit = "kg/m3") "the density of the crown";
Real vc_m(unit = "m3")"The volume of the water displaced in m3";

//equation section
equation
//refer fig 3.28 for better reference
vc_m=vc_cc*10^(-6);//conversion of cm3 to m3
w=f+(rho*g*vc_m);
rho_c=w/(vc_m*g);
end Ex3_4;
//===================================================================
//Error in the calculated value: Instead of 7880 kg/m3 the simulation shows 7872.5 kg/m3
