//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-3:
  //Example: 4.7 Page 121
  //Title: Velocity of a water balloon
  //===================================================================
model Ex4_7
import SI=Modelica.SIunits;

//parameter section
SI.Density rho_water=1000 "The desnity of water";
parameter Real p(unit = "N/m2")=100000 "The pressure inside the balloon";
SI.Mass mo=1.5 "The mass of the water filled in balloon";
SI.Mass ms=0.5"The mass of the system without water";

//variable section
SI.Velocity ue "The exit velocity of the system";
SI.Velocity uf "The final velocity of the system";

equation
//equation section
ue=(2*p/rho_water)^0.5;
uf=ue*Modelica.Math.log(mo/ms);//we can see that the final velocity is greater than the exit speed
end Ex4_7;
//===================================================================
