//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-4:
  //Example: 4.8 Page 123
  //Title: Measuring Airspeed in a wind tunnel
  //===================================================================
model Ex4_8
import SI=Modelica.SIunits;

//parameter section
parameter Real rho_water(unit = "Kg/m3")=1000 "The density of water";
parameter SI.Acceleration g=9.8 "Acceleration due to gravity";
parameter SI.Length h=0.2 "THE height of water column";
parameter Real rho_air(unit = "Kg/m3")=1.2 "The density of air";

//variable section 
Real p_diff(unit = "N/m2") "The difference in pressure";
SI.Velocity u "The airspeed of the wind tunnel";
Real u1(unit = "km/h") "The velocity on km/h";

//equation section
equation
p_diff=rho_water*g*h;
u=(2*p_diff/rho_air)^0.5;
u1=u*3600/1000;
end Ex4_8;
//===================================================================
