//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-5: Incompressible flow:Exact solutions
  //Example: 5.13 Page 185
  //Title: Flow in a trapezoidal channel
  //===================================================================
model Ex5_13
import SI=Modelica.SIunits;

//parameter section
parameter SI.Length h=0.8 "The height of the trapezoidal channel";
parameter SI.Length b=1 "The base/ smaller width of the trapezoidal channel";
parameter Real n=0.012 "The manning coefficient";
parameter Real slope=pi/180*0.3 "The slope of the channel";
final constant Real pi=2*Modelica.Math.asin(1.0);//the value of pi

//variable section
SI.Area s "The cross sectional area of the channel";
SI.Length ph "The hydraulic perimeter";
SI.Length rh "The hydraulic radius";
SI.Velocity u_av "The average velocity";
Real q(unit = "m3/s");

//equation section
equation
//from the figure 5.30 we find the angle of inclination of the trapezium side is 60 degree
s=h*(b+(h/tan(pi/3)));
ph=1+(2*h/sin(pi/3));
rh=s/ph;//the hydraulic radius is required for u_av calculation
//from the equation 5.139 mentioned on page 184, we find the average velocity
//manning coefficient is used in that equation mentioned. so we also use manning coefficient taken from table 5.1
u_av=(1/n)*rh^(2/3)*(tan(slope))^0.5;
q=u_av*s;//the flow rate
end Ex5_13;
//===================================================================
