//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-5:Viscous Incompressible flow:Exact solutions
  //Example: 5.2 Page 148
  //Title: Flow between two parallel plates with no pressure gradient
  //===================================================================
model Ex5_2
import SI=Modelica.SIunits;
//this question is based on the derivation in example 5.1
parameter SI.Velocity u=5 "The movement of upper plate with respect to lower";
parameter SI.Length h=0.01 "The clearance between plates";
parameter SI.DynamicViscosity mu_water=0.001 "The viscosity of water";
parameter SI.Area s=1 "The contact area of water with plates";

//variable section
SI.VolumeFlowRate q "The flow rate per unit width";
SI.Velocity u_avg "The average velocity";
SI.ShearStress t_xz "The shear stress per unit width at the wall";
SI.Force f "The force required for pulling unit area";

//equation section
equation
u_avg=u/2;
q=u*h/2;
t_xz=mu_water*u/h;
f=t_xz*s;
end Ex5_2;
//===================================================================

