//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-5:Viscous Incompressible flow:Exact solutions
  //Example: 5.5 Page 161
  //Title: Pressure drop in a cicular pipe
  //===================================================================
model Ex5_5
import SI=Modelica.SIunits;
final Real pi=2*Modelica.Math.asin(1);//value of pi

//parameter section 
parameter SI.Length d=0.012 "The diameter of the circular pipe";
parameter SI.VolumeFlowRate q=8.333*10^(-6) "The flow rate of kerosene in the pipe at 20 deg C";
//The values of density and viscosity of kerosene at 20 degC is obtained from the table 1.1
//With these values we can easily get pressure gradient and average velocity via the Eq5.84
parameter SI.DynamicViscosity mu=1.9*10^(-3) "The viscosity of kerosene at 20 deg C";
parameter Real rho(unit = "kg/m3")=814 "The desnity of Kerosene at 20 Deg C";

//variable section
 Real der_p(unit = "Pa/m") "The pressure drop gradient";
SI.Velocity u_av "The average velocity";
Real re "The reynolds number";

//equation section
equation
//As menitoned above the equation below is obtained from Eq5.84
der_p=-q*8*mu/(pi*(d/2)^4);
u_av=q/(pi*(d/2)^2);
re=rho*u_av*d/mu;
//Therefore this calculation is well within the range of this model Refer fig 5.10
end Ex5_5;
//error: Negative sign missing in der_p calcultion in the book but it is mentioned in the 
//       formula given. hence der_p=-31.2 Pa/m instead of 31.2 Pa/m 
//===================================================================
