//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-8:High Reynolds Number flow over Bodies (Incompressible)
  //Example: 8.10 Page 285
  //Title: Aerodynamic drag
  //===================================================================
model Ex8_10
import SI=Modelica.SIunits;

//parameter section
parameter SI.Area s=0.36 "The average frontal area of the bicycle rider";
parameter Real rho_air(unit = "kg/m3")=1.2 "The density of air";
parameter SI.Velocity u=(25/3.6) "The velocity of the bicycle rider";
parameter Real t =3600 "The time in seconds";

//variable section
Real cd "The drag coefficient";
SI.Force d "The total drag force on the bicycle rider";
SI.Power p "The power required during one hour";
Real e(unit = "J") "The energy required in one hour";
Real e_kJ(unit = "kJ")"The enrgy required in kilo Joules";
Real e_kCal(unit = "kCal")"The energy required in kilo Calories";

//equation section
equation
//from the figure 8.25 we find that the cd is 0.88
cd=0.88;
d=cd*0.5*rho_air*u*u*s;
//the power is force times velocity
p=d*u;
e=p*t;
e_kJ=e/1000;
e_kCal=e_kJ/4.18;
//now he can hit his ice cream
end Ex8_10;
//variation: enregy spent e_kJ=229.2 kJ according to book
//           energy spent e_kJ=229.167 kJ in simulation
//Variation: energy spent e_kCal=54.6 kCal according to the book
//           energy spent e_kCal=54.82 kCal in simulation
//===================================================================
