//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-8:High Reynolds Number flow over Bodies (Incompressible)
  //Example: 8.12 Page 286
  //Title: Terminal velocity of a parachute
  //===================================================================
model Ex8_12
import SI=Modelica.SIunits;
final constant Real pi=2*Modelica.Math.asin(1);//the value of pi

//parameter section
parameter SI.Mass m=90 "The mass of a paratrooper";
parameter SI.Length d=6 "The diameter of the chute";
parameter Real rho_air(unit = "kg/m3")=1.2 "The density of air";
parameter SI.Acceleration g=9.8 "The acce;eration due to gravity";

//variable section 
Real cd "The drag coefficient of the chute";
SI.Velocity u "The sinking velocity of the parachute";

//equation section
equation
//we find the the drag coefficient from the figure 8.25
cd=1.2;
//in steady state the drag of the parachute is equal to the weight of the parachutist(neglect the weight of chute)
u=(2*m*g/(cd*rho_air*pi*(d/2)^2))^0.5;
//this is too fast and paratrooper must loose some weight
end Ex8_12;
//===================================================================
