//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-8:High Reynolds Number flow over Bodies (Incompressible)
  //Example: 8.17 Page 292
  //Title: Lift of a rotating ball
  //===================================================================
model Ex8_17
import SI=Modelica.SIunits;
final constant Real pi=2*Modelica.Math.asin(1.0);//the value of pi

//parameter section
parameter SI.Length d=0.03 "The diameter of the ping pong ball";
parameter SI.Velocity u=11 "The velocity of the ball";
parameter Real r(unit = "1/s")=7000 "The rotation of the ball";
parameter Real rho_ball(unit = "kg/m3")=1.2 "The density of the ball";

//variable section
Real xr "The non dimensional rotation parameter";
Real cl "The coefficient of lift";
Real cd "The drag coefficient";
SI.Force l "The force due to lift";
SI.Force dr "The total drag force";

//equation section
equation
xr=(d/2)*(2*pi)*(r/60)/u;
//the lift and drag coefficients are taken from the figure 8.30 b
cl=0.27;
cd=0.63;
//the corresponding forces for the lift and drag are
l=cl*0.5*rho_ball*u*u*pi*(d/2)^2;
dr=cd*0.5*rho_ball*u*u*pi*(d/2)^2;
end Ex8_17;
//if the ball moves to the left and the rotation is in the direction shown in fig 8.30 B , then ball will experience lift.
//===================================================================
